
<link href='/chalhoub/js/fullcalendaer/core/main.css' rel='stylesheet' />
<link href='/chalhoub/js/fullcalendaer/daygrid/main.css' rel='stylesheet' />
<link href='/chalhoub/js/fullcalendaer/timegrid/main.css' rel='stylesheet' />
<link href='/chalhoub/js/fullcalendaer/list/main.css' rel='stylesheet' />
<script src='/chalhoub/js/fullcalendaer/core/main.js'></script>
<script src='/chalhoub/js/fullcalendaer/interaction/main.js'></script>
<script src='/chalhoub/js/fullcalendaer/daygrid/main.js'></script>
<script src='/chalhoub/js/fullcalendaer/timegrid/main.js'></script>
<script src='/chalhoub/js/fullcalendaer/list/main.js'></script>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("load", '
        $(document).ready(function() {

        var table_id ="#table_meeting_summary";
        var table = $(table_id).DataTable({
            scrollY         : "450px",
            "bAutoWidth": true,
            pageLength      : 50,
            ajax: {
                url: "' . Yii::app()->createUrl('meeting/getList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            order: [[ 1, "desc" ]],
            
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-map"></i> Meeting


        <div class="pull-right">
            <div class="pull-left">
                <select class="btn-sm" onchange="ChangeView(this.value)" >
                    <option value="1">Summary</option>
                    <option value="2">Detail</option>
                    <option value="3">Calendar</option>
                </select>
                <?php if (isset(Yii::app()->user->havePermissionOn['category_add']) || Yii::app()->user->authorised_user == '1') { ?>                    
                    <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('meeting/create', 'Add', 'md')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?>
            </div><div class="pull-left">
                &nbsp;<input type="button" value="Back" onclick="window.history.back();return false;" class='btn btn-sm btn-danger' style="margin-right: 10px;" />
            </div>
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <div id="meeting_summary" style="display: none">
                <table class="table table-hover table-bordered personal-task" id="table_meeting_summary">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Title</th>                            
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Title</th>                            
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <div id="meeting_deatils" style="display: none">
                <table  class="table table-hover table-bordered personal-task" id="table_meeting_details">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Meeting</th>
                            <th>Date</th>
                            <th>Title</th>
                            <th>Details</th>  
                            <th>Person</th>
                            <th>Closing</th>
                            <th>Status</th>                          
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Meeting</th>
                            <th>Date</th>
                            <th>Title</th>
                            <th>Details</th>  
                            <th>Person</th>
                            <th>Closing</th>
                            <th>Status</th>                          
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <div id="calendar-view" style="padding:  50px;">
                <div id='calendar-container'>
                    <div id='calendar'></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script type="text/javascript">

    function ChangeView(val) {
        if (val == "1") {
            $("#meeting_deatils").hide();
            $("#calendar-view").hide();
            $("#meeting_summary").show();
            $('#table_meeting_summary').DataTable().ajax.reload();
        } else if (val == "2") {
            $("#meeting_deatils").show();
            $("#meeting_summary").hide();
            $("#calendar-view").hide();
            $('#table_meeting_details').DataTable().ajax.reload();
        } else if (val == "3") {
            $("#meeting_deatils").hide();
            $("#meeting_summary").hide();
            $("#calendar-view").show();
        }
    }
    function CloseTransation(val) {
        var dr = confirm("Do you want to Close this item?");
        if (dr) {
            jQuery.ajax({
                dataType: 'json',
                data: {'id': val},
                type: 'post',
                url: '<?= Yii::app()->createUrl('meeting/CloseTransation') ?>',
                'cache': false,
                'success': function (data) {
                    if (data.status == "success") {
                        t8.success("Closed");
                        $('#table_meeting_details').DataTable().ajax.reload();
                    }
                }
            });
        }
    }

    $(document).ready(function () {

        var table_details_id = "#table_meeting_details";
        var table_details = $(table_details_id).DataTable({
            scrollY: "450px",
            "bAutoWidth": true,
            pageLength: 50,
            ajax: {
                url: "<?= Yii::app()->createUrl('meeting/GetDetailsList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            order: [[6, "asc"]],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                

                if (aData[7] == "Closed") {
                    $("td", nRow).addClass("bg-success");
                }
                if (aData[9] == true) {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
        $(".dataTables_scrollFoot").hide();
    });
</script>
<script>
 document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
      plugins: [ 'interaction', 'dayGrid', 'timeGrid', 'list' ],
      height: 'parent',
      header: {
        left: 'prev,next today',
        center: 'title',
        right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
      },
      defaultView: 'dayGridMonth',
      defaultDate: '2020-02-12',
      navLinks: true, // can click day/week names to navigate views
      editable: true,
      eventLimit: true, // allow "more" link when too many events
      events: [
        {
          title: 'All Day Event',
          start: '2020-02-01',
        },
        {
          title: 'Long Event',
          start: '2020-02-07',
          end: '2020-02-10'
        },
        {
          groupId: 999,
          title: 'Repeating Event',
          start: '2020-02-09T16:00:00'
        },
        {
          groupId: 999,
          title: 'Repeating Event',
          start: '2020-02-16T16:00:00'
        },
        {
          title: 'Conference',
          start: '2020-02-11',
          end: '2020-02-13'
        },
        {
          title: 'Meeting',
          start: '2020-02-12T10:30:00',
          end: '2020-02-12T12:30:00'
        },
        {
          title: 'Lunch',
          start: '2020-02-12T12:00:00'
        },
        {
          title: 'Meeting',
          start: '2020-02-12T14:30:00'
        },
        {
          title: 'Happy Hour',
          start: '2020-02-12T17:30:00'
        },
        {
          title: 'Dinner',
          start: '2020-02-12T20:00:00'
        },
        {
          title: 'Birthday Party',
          start: '2020-02-13T07:00:00'
        },
        {
          title: 'Click for Google',
          url: 'http://google.com/',
          start: '2020-02-28'
        }
      ]
    });

    calendar.render();
  });
</script>